local NumColumns = GAMESTATE:GetCurrentStyle():ColumnsPerPlayer()
local pn = ToEnumShortString(PLAYER_1)
local mods = MetroQuad[pn].ActiveModifiers
local Mini = GAMESTATE:GetPlayerState(PLAYER_1):GetPlayerOptions(0):Mini()

if not mods or mods.ColumnFlashed == "Off" then
	return Def.Actor{}
end

local af = Def.ActorFrame{
	InitCommand=function(self)
		self:xy(PlayFieldPositionFlashedColumn(PLAYER_1), _screen.cy )
		local zoom_factor = 1 - scale( Mini, 0, 2, 0, 1)
		self:zoomx(zoom_factor)
	end
}

for ColumnIndex=0,NumColumns-1 do
	af[#af+1] = Def.Quad{
		InitCommand=function(self)
			self:diffuse(0,0,0,0)
			if not mods.ColumnFlashed then
				self:hibernate(math.huge)
			else
				local style = GAMESTATE:GetCurrentStyle(PLAYER_1)
				local width = style:GetWidth(PLAYER_1)
				self:x((ColumnIndex-1.5) * (width/NumColumns))
				self:setsize(width/NumColumns,Height()-80)
				self:fadebottom(0.25)
			end
        end,
		JudgmentMessageCommand=function(self, params)
			local Game = GAMESTATE:GetCurrentGame():GetName()
			local Style = GAMESTATE:GetCurrentStyle():GetName()
			
			if Game == "pump" then
				if Style == "double" then
					return Def.Actor{}
				else
					if mods.ColumnFlashed == "Perfect" then
						if params.Player == PLAYER_1 and params.FirstTrack == ColumnIndex then
							local tns = ToEnumShortString(params.TapNoteScore)
							if tns == "W2" then
								self:diffuse(color(jColors[2]))
								self:accelerate(0.165):diffuse(0,0,0,0)
							end
						end
					end
					if mods.ColumnFlashed == "Great" then
						if params.Player == PLAYER_1 and params.FirstTrack == ColumnIndex then
							local tns = ToEnumShortString(params.TapNoteScore)
							if tns == "W3" then
								self:diffuse(color(jColors[3]))
								self:accelerate(0.165):diffuse(0,0,0,0)
							end
						end
					end
					if mods.ColumnFlashed == "Good" then
						if params.Player == PLAYER_1 and params.FirstTrack == ColumnIndex then
							local tns = ToEnumShortString(params.TapNoteScore)
							if tns == "W4" then
								self:diffuse(color(jColors[4]))
								self:accelerate(0.165):diffuse(0,0,0,0)
							end
						end
					end
					if mods.ColumnFlashed == "Bad" then
						if params.Player == PLAYER_1 and params.FirstTrack == ColumnIndex then
							local tns = ToEnumShortString(params.TapNoteScore)
							if tns == "W5" then
								self:diffuse(color(jColors[5]))
								self:accelerate(0.165):diffuse(0,0,0,0)
							end
						end
					end
					if mods.ColumnFlashed == "Miss" then
						if params.Player == PLAYER_1 and params.FirstTrack == ColumnIndex then
							local tns = ToEnumShortString(params.TapNoteScore)
							if tns == "Miss" then
								self:diffuse(color(jColors[6]))
								self:accelerate(0.165):diffuse(0,0,0,0)
							end
						end
					end
				end
			else
				if mods.ColumnFlashed == "All" then
					if params.Player == PLAYER_1 and params.FirstTrack == ColumnIndex then
						local tns = ToEnumShortString(params.TapNoteScore)
						for Taps in pairs(tJudgments.tapsToColor) do
							if tns == Taps then
								self:diffuse(color(tJudgments.tapsToColor[tns]))
								self:accelerate(0.165):diffuse(0,0,0,0)
							end
						end
					end
				end
				if mods.ColumnFlashed == "Perfect" then
					if params.Player == PLAYER_1 and params.FirstTrack == ColumnIndex then
						local tns = ToEnumShortString(params.TapNoteScore)
						if tns == "W2" then
							self:diffuse(color(jColors[2]))
							self:accelerate(0.165):diffuse(0,0,0,0)
						end
					end
				end
				if mods.ColumnFlashed == "Great" then
					if params.Player == PLAYER_1 and params.FirstTrack == ColumnIndex then
						local tns = ToEnumShortString(params.TapNoteScore)
						if tns == "W3" then
							self:diffuse(color(jColors[3]))
							self:accelerate(0.165):diffuse(0,0,0,0)
						end
					end
				end
				if mods.ColumnFlashed == "Good" then
					if params.Player == PLAYER_1 and params.FirstTrack == ColumnIndex then
						local tns = ToEnumShortString(params.TapNoteScore)
						if tns == "W4" then
							self:diffuse(color(jColors[4]))
							self:accelerate(0.165):diffuse(0,0,0,0)
						end
					end
				end
				if mods.ColumnFlashed == "Bad" then
					if params.Player == PLAYER_1 and params.FirstTrack == ColumnIndex then
						local tns = ToEnumShortString(params.TapNoteScore)
						if tns == "W5" then
							self:diffuse(color(jColors[5]))
							self:accelerate(0.165):diffuse(0,0,0,0)
						end
					end
				end
				if mods.ColumnFlashed == "Miss" then
					if params.Player == PLAYER_1 and params.FirstTrack == ColumnIndex then
						local tns = ToEnumShortString(params.TapNoteScore)
						if tns == "Miss" then
							self:diffuse(color(jColors[6]))
							self:accelerate(0.165):diffuse(0,0,0,0)
						end
					end
				end
			end
		end
	}
end

return af